#!/bin/bash
#SBATCH --job-name diamond_example
#SBATCH -A workshop
#SBATCH --time=00:30:00
#SBATCH -N 1
#SBATCH -n 36
#SBATCH -p long
#SBATCH --qos normal
#SBATCH --output job.out
#SBATCH --error job.err

module load intel/PSXE2017 
module load mvapich2/2.1-intel 
module load Quantum_ESPRESSO/5.4

export OCEAN_BIN=/hpcgpfs01/work/workshop/ocean_tutorial/bin/

# First run a regular XAS calculation
$OCEAN_BIN/ocean.pl diamond.in

# Switch from using Haydock to GMRES
echo gmres > Common/cnbse.solver

# Run for every energy in a range (same energy scale as the absorption spectra)
# start stop step, ie, run for 0, 2, 4, ... 30
echo 0  30.1  2 > Common/cnbse.gmres.erange

mkdir RIXS
# Which photon file(s) is/are incoming (can be a list)
echo 1 > RIXS/photon_in
# Which photon file(s) is/are outgoing (can be a list)
echo 2 > RIXS/photon_out

cd RIXS
$OCEAN_BIN/rixs.pl
